<?php
require_once 'config.php';
require_once 'db.php';

// سیستم لاگ
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function var_log($message) {
    $log_message = '[' . date('Y-m-d H:i:s') . '] - ' . print_r($message, true) . "\n";
    file_put_contents('log.txt', $log_message, FILE_APPEND);
}

set_error_handler(function($severity, $message, $file, $line) {
    var_log("PHP Error: [{$severity}] {$message} in {$file} on line {$line}");
});

// توابع API تلگرام
function apiRequest($method, $data = []) {
    $url = 'https://api.telegram.org/bot' . BOT_TOKEN . '/' . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_log('cURL Error: ' . curl_error($ch));
        return false;
    }
    curl_close($ch);
    return json_decode($res, true);
}

function sendMessage($chat_id, $text, $keyboard = null) {
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }
    return apiRequest('sendMessage', $data);
}

function sendFile($chat_id, $file_id, $file_type, $caption = '') {
    $data = ['chat_id' => $chat_id];
    $method = '';
    
    if (!empty($caption)) {
        $data['caption'] = $caption;
        $data['parse_mode'] = 'HTML';
    }
    
    switch ($file_type) {
        case 'document': 
            $data['document'] = $file_id; 
            $method = 'sendDocument'; 
            break;
        case 'video': 
            $data['video'] = $file_id; 
            $method = 'sendVideo'; 
            break;
        case 'photo': 
            $data['photo'] = $file_id; 
            $method = 'sendPhoto'; 
            break;
    }
    
    if ($method) {
        return apiRequest($method, $data);
    }
    return false;
}

// تابع جدید برای دریافت کپشن فعال
function getActiveCaption() {
    global $conn;
    $stmt = $conn->prepare("SELECT caption_text FROM captions WHERE is_active = TRUE LIMIT 1");
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($caption_text);
        $stmt->fetch();
        $stmt->close();
        return $caption_text;
    }
    $stmt->close();
    return '';
}

// منطق اصلی ربات
$update = json_decode(file_get_contents('php://input'), true);
if (!$update) { 
    var_log("No update received");
    exit(); 
}

var_log("Update received: " . print_r($update, true));

if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $text = $message['text'] ?? '';
    
    // ثبت کاربر در دیتابیس
    $stmt = $conn->prepare("INSERT INTO users (user_id, first_name, username) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE first_name = ?, username = ?");
    $first_name = $message['from']['first_name'];
    $username = $message['from']['username'] ?? null;
    $stmt->bind_param("issss", $user_id, $first_name, $username, $first_name, $username);
    $stmt->execute();
    
    // بخش ادمین
    if ($user_id == ADMIN_ID) {
        // وضعیت ادمین
        $stmt_state = $conn->prepare("SELECT admin_state, current_batch_code FROM users WHERE user_id = ?");
        $stmt_state->bind_param("i", $user_id);
        $stmt_state->execute();
        $stmt_state->store_result();
        $stmt_state->bind_result($admin_state, $current_batch_code);
        $stmt_state->fetch();
        $stmt_state->close();

        // بررسی پیام رسانه‌ای
        if (isset($message['document']) || isset($message['video']) || isset($message['photo'])) {
            if ($admin_state == 'awaiting_broadcast') {
                $message_id = $message['message_id'];
                $stmt_broadcast = $conn->prepare("INSERT INTO broadcasts (admin_id, message_id, status) VALUES (?, ?, 'pending')");
                $stmt_broadcast->bind_param("ii", $user_id, $message_id);
                $stmt_broadcast->execute();
                
                $stmt_reset = $conn->prepare("UPDATE users SET admin_state = NULL WHERE user_id = ?");
                $stmt_reset->bind_param("i", $user_id);
                $stmt_reset->execute();
                sendMessage($chat_id, "✅ پیام شما در صف ارسال همگانی قرار گرفت. ارسال به زودی توسط کرون جاب آغاز خواهد شد.");
                var_log("Broadcast message queued: " . $message_id);
                
            } elseif ($admin_state == 'bulk_uploading') {
                $batch_code = $current_batch_code;
                if (!$batch_code) {
                    $batch_code = 'batch_' . bin2hex(random_bytes(5));
                    $stmt_update = $conn->prepare("UPDATE users SET current_batch_code = ? WHERE user_id = ?");
                    $stmt_update->bind_param("si", $batch_code, $user_id);
                    $stmt_update->execute();
                }
                
                $file = $message['document'] ?? $message['video'] ?? $message['photo'][count($message['photo'])-1];
                $file_id = $file['file_id'];
                $file_type = isset($message['document']) ? 'document' : (isset($message['video']) ? 'video' : 'photo');

                $stmt_file = $conn->prepare("INSERT INTO files (admin_id, file_id, file_type, batch_code) VALUES (?, ?, ?, ?)");
                $stmt_file->bind_param("isss", $user_id, $file_id, $file_type, $batch_code);
                $stmt_file->execute();
                sendMessage($chat_id, "فایل دریافت شد. می‌توانید فایل بعدی را ارسال کنید.");
                
            } else {
                 sendMessage($chat_id, "❗️برای آپلود فایل، لطفا ابتدا از منوی اصلی روی دکمه '📤 آپلود گروهی' کلیک کنید.");
            }
        } else {
            // پردازش دستورات متنی
            switch ($text) {
                case '/start':
                case '/admin':
                    $keyboard = ['keyboard' => [
                        [['text' => '📊 آمار'], ['text' => '🔗 مدیریت عضویت اجباری']],
                        [['text' => '📤 آپلود گروهی'], ['text' => '📢 پیام همگانی']],
                        [['text' => '📝 مدیریت کپشن'], ['text' => '⚙️ تنظیمات']]
                    ], 'resize_keyboard' => true];
                    sendMessage($chat_id, "به پنل ادمین خوش آمدید.", $keyboard);
                    break;

                case '📊 آمار':
                    $users_count = $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
                    $channels_count = $conn->query("SELECT COUNT(*) as count FROM user_target_channels")->fetch_assoc()['count'];
                    $files_count = $conn->query("SELECT COUNT(*) as count FROM files")->fetch_assoc()['count'];
                    $active_caption = $conn->query("SELECT COUNT(*) as count FROM captions WHERE is_active = TRUE")->fetch_assoc()['count'];
                    
                    sendMessage($chat_id, "📊 <b>آمار ربات:</b>\n\n👥 کاربران: {$users_count}\n📺 کانال‌ها: {$channels_count}\n📁 فایل‌ها: {$files_count}\n📝 کپشن فعال: " . ($active_caption ? '✅' : '❌'));
                    break;

                case '🔗 مدیریت عضویت اجباری':
                    $channels_res = $conn->query("SELECT channel_username FROM forced_channels");
                    $list = "📋 لیست کانال های اجباری:\n";
                    if($channels_res->num_rows > 0) {
                        while($row = $channels_res->fetch_assoc()){ 
                            $list .= "➖ " . $row['channel_username'] . "\n"; 
                        }
                    } else { 
                        $list .= "<i>(هیچ کانالی ثبت نشده)</i>\n"; 
                    }
                    $list .= "\nبرای افزودن: <code>/add @ChannelUsername</code>\nبرای حذف: <code>/del @ChannelUsername</code>";
                    sendMessage($chat_id, $list);
                    break;
                
                case '📤 آپلود گروهی':
                    $stmt = $conn->prepare("UPDATE users SET admin_state = 'bulk_uploading', current_batch_code = NULL WHERE user_id = ?");
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    $keyboard = ['keyboard' => [[['text' => '✅ پایان آپلود و دریافت لینک']]], 'resize_keyboard' => true];
                    sendMessage($chat_id, "📤 شما در حالت <b>آپلود گروهی</b> هستید.\n\nفایل‌های خود را ارسال کنید و در پایان روی دکمه زیر کلیک کنید.", $keyboard);
                    break;
                
                case '✅ پایان آپلود و دریافت لینک':
                    if ($current_batch_code) {
                        $file_count = $conn->query("SELECT COUNT(*) as count FROM files WHERE batch_code = '{$current_batch_code}'")->fetch_assoc()['count'];
                        $bot_info = apiRequest('getMe');
                        $bot_username = $bot_info['result']['username'];
                        $share_link = "https://t.me/{$bot_username}?start={$current_batch_code}";
                        sendMessage($chat_id, "✅ عملیات آپلود گروهی با موفقیت به پایان رسید.\n📁 تعداد فایل‌ها: {$file_count}\n\n🔗 لینک اشتراک‌گذاری:\n<code>{$share_link}</code>");
                    } else {
                        sendMessage($chat_id, "❌ هنوز هیچ فایلی برای این گروه آپلود نکرده‌اید.");
                    }
                    $stmt = $conn->prepare("UPDATE users SET admin_state = NULL, current_batch_code = NULL WHERE user_id = ?");
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    
                    $keyboard = ['keyboard' => [
                        [['text' => '📊 آمار'], ['text' => '🔗 مدیریت عضویت اجباری']],
                        [['text' => '📤 آپلود گروهی'], ['text' => '📢 پیام همگانی']],
                        [['text' => '📝 مدیریت کپشن'], ['text' => '⚙️ تنظیمات']]
                    ], 'resize_keyboard' => true];
                    sendMessage($chat_id, "به منوی اصلی بازگشتید.", $keyboard);
                    break;
                
                case '📢 پیام همگانی':
                    $stmt = $conn->prepare("UPDATE users SET admin_state = 'awaiting_broadcast' WHERE user_id = ?");
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    sendMessage($chat_id, "📢 لطفا پیامی که می‌خواهید برای همه ارسال شود را بفرستید (متن، عکس، ویدیو و...).\n\nاین پیام عینا برای همه کاربران و کانال‌ها فوروارد خواهد شد.");
                    var_log("Admin set to awaiting_broadcast state");
                    break;
                
                case '📝 مدیریت کپشن':
                    $keyboard = ['keyboard' => [
                        [['text' => '➕ افزودن کپشن']],
                        [['text' => '🗑 حذف کپشن فعلی']],
                        [['text' => '📋 مشاهده کپشن فعلی']],
                        [['text' => '🔙 بازگشت']]
                    ], 'resize_keyboard' => true];
                    
                    $active_caption = getActiveCaption();
                    $status = $active_caption ? "✅ فعال" : "❌ غیرفعال";
                    sendMessage($chat_id, "📝 <b>مدیریت کپشن</b>\n\nوضعیت: {$status}\n\nکپشن فعلی:\n<code>" . ($active_caption ?: 'بدون کپشن') . "</code>", $keyboard);
                    break;
                
                case '➕ افزودن کپشن':
                    $stmt = $conn->prepare("UPDATE users SET admin_state = 'awaiting_caption' WHERE user_id = ?");
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    sendMessage($chat_id, "📝 لطفا متن کپشن مورد نظر را ارسال کنید:\n\nاین کپشن در زیر تمام فایل‌هایی که برای کاربران ارسال می‌شود نمایش داده خواهد شد.");
                    break;
                
                case '🗑 حذف کپشن فعلی':
                    $stmt = $conn->prepare("UPDATE captions SET is_active = FALSE WHERE is_active = TRUE");
                    $stmt->execute();
                    
                    if ($stmt->affected_rows > 0) {
                        sendMessage($chat_id, "✅ کپشن فعلی با موفقیت حذف شد.");
                    } else {
                        sendMessage($chat_id, "❌ کپشن فعالی برای حذف وجود ندارد.");
                    }
                    break;
                
                case '📋 مشاهده کپشن فعلی':
                    $active_caption = getActiveCaption();
                    if ($active_caption) {
                        sendMessage($chat_id, "📝 <b>کپشن فعلی:</b>\n\n<code>{$active_caption}</code>");
                    } else {
                        sendMessage($chat_id, "❌ هیچ کپشن فعالی وجود ندارد.");
                    }
                    break;
                
                case '🔙 بازگشت':
                    $keyboard = ['keyboard' => [
                        [['text' => '📊 آمار'], ['text' => '🔗 مدیریت عضویت اجباری']],
                        [['text' => '📤 آپلود گروهی'], ['text' => '📢 پیام همگانی']],
                        [['text' => '📝 مدیریت کپشن'], ['text' => '⚙️ تنظیمات']]
                    ], 'resize_keyboard' => true];
                    sendMessage($chat_id, "به منوی اصلی بازگشتید.", $keyboard);
                    break;
                
                case '⚙️ تنظیمات':
                    sendMessage($chat_id, "⚙️ <b>تنظیمات</b>\n\nاین بخش به زودی اضافه خواهد شد...");
                    break;
                
                default:
                    // پردازش وضعیت‌های خاص
                    if ($admin_state == 'awaiting_caption') {
                        // غیرفعال کردن کپشن‌های قبلی
                        $stmt_deactivate = $conn->prepare("UPDATE captions SET is_active = FALSE WHERE is_active = TRUE");
                        $stmt_deactivate->execute();
                        
                        // ذخیره کپشن جدید
                        $stmt_caption = $conn->prepare("INSERT INTO captions (admin_id, caption_text, is_active) VALUES (?, ?, TRUE)");
                        $stmt_caption->bind_param("is", $user_id, $text);
                        $stmt_caption->execute();
                        
                        // بازگشت به حالت عادی
                        $stmt_reset = $conn->prepare("UPDATE users SET admin_state = NULL WHERE user_id = ?");
                        $stmt_reset->bind_param("i", $user_id);
                        $stmt_reset->execute();
                        
                        sendMessage($chat_id, "✅ کپشن با موفقیت ذخیره شد و فعال گردید.\n\n📝 کپشن:\n<code>{$text}</code>");
                        var_log("Caption saved: " . $text);
                    
                    } elseif ($admin_state == 'awaiting_broadcast') {
                        // اگر ادمین در حالت انتظار برای پیام همگانی بود و متن فرستاد
                        $message_id = $message['message_id'];
                        $stmt_broadcast = $conn->prepare("INSERT INTO broadcasts (admin_id, message_id, status) VALUES (?, ?, 'pending')");
                        $stmt_broadcast->bind_param("ii", $user_id, $message_id);
                        $stmt_broadcast->execute();
                        
                        $stmt_reset = $conn->prepare("UPDATE users SET admin_state = NULL WHERE user_id = ?");
                        $stmt_reset->bind_param("i", $user_id);
                        $stmt_reset->execute();
                        sendMessage($chat_id, "✅ پیام شما در صف ارسال همگانی قرار گرفت. ارسال به زودی توسط کرون جاب آغاز خواهد شد.");
                        var_log("Text broadcast queued: " . $message_id);
                    
                    } elseif (strpos($text, '/add ') === 0) {
                        $channel = trim(substr($text, 5));
                        if (strpos($channel, '@') === 0) {
                            $stmt = $conn->prepare("INSERT INTO forced_channels (channel_username) VALUES (?) ON DUPLICATE KEY UPDATE channel_username = ?");
                            $stmt->bind_param("ss", $channel, $channel);
                            if($stmt->execute()){ 
                                sendMessage($chat_id, "✅ کانال {$channel} با موفقیت اضافه شد."); 
                            }
                        } else { 
                            sendMessage($chat_id, "❌ فرمت نامعتبر است. مثال: <code>/add @MyChannel</code>"); 
                        }
                    } elseif (strpos($text, '/del ') === 0) {
                        $channel = trim(substr($text, 5));
                         if (strpos($channel, '@') === 0) {
                            $stmt = $conn->prepare("DELETE FROM forced_channels WHERE channel_username = ?");
                            $stmt->bind_param("s", $channel);
                            if($stmt->execute()){ 
                                sendMessage($chat_id, "🗑 کانال {$channel} با موفقیت حذف شد."); 
                            }
                        } else { 
                            sendMessage($chat_id, "❌ فرمت نامعتبر است. مثال: <code>/del @MyChannel</code>"); 
                        }
                    }
                    break;
            }
        }
    }
    
    // بخش کاربر
    elseif (strpos($text, '/start ') === 0) {
        $batch_code = trim(substr($text, 7));
        var_log("User started with batch code: " . $batch_code);
        
        $stmt = $conn->prepare("SELECT file_id, file_type FROM files WHERE batch_code = ?");
        $stmt->bind_param("s", $batch_code);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows == 0) {
            sendMessage($chat_id, "❌ لینک فایل نامعتبر است یا منقضی شده.");
            exit();
        }
        
        $stmt->bind_result($file_id_db, $file_type_db);
        $files_to_send = [];
        while($stmt->fetch()) {
            $files_to_send[] = ['file_id' => $file_id_db, 'file_type' => $file_type_db];
        }
        $stmt->close();

        // چک عضویت اجباری
        $channels_res = $conn->query("SELECT channel_username FROM forced_channels");
        $must_join = [];
        if ($channels_res->num_rows > 0) {
            while($row = $channels_res->fetch_assoc()){
                $status = apiRequest('getChatMember', ['chat_id' => $row['channel_username'], 'user_id' => $user_id]);
                if (!$status || !$status['ok'] || !in_array($status['result']['status'], ['member', 'administrator', 'creator'])) {
                    $must_join[] = ['text' => '👉 عضویت در ' . $row['channel_username'], 'url' => 'https://t.me/' . str_replace('@', '', $row['channel_username'])];
                }
            }
        }
        
        if (!empty($must_join)) {
            $keyboard = ['inline_keyboard' => array_chunk($must_join, 1)];
            sendMessage($chat_id, "❗️ برای دریافت فایل‌ها، ابتدا باید در کانال های زیر عضو شوید و سپس دوباره روی لینک کلیک کنید.", $keyboard);
            exit();
        }
        
        // چک کانال هدف
        $stmt = $conn->prepare("SELECT channel_id FROM user_target_channels WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->store_result();
        
        if($stmt->num_rows == 0) {
            $bot_info = apiRequest('getMe');
            $bot_username = $bot_info['result']['username'];
            $invite_link = "https://t.me/{$bot_username}?startchannel=true&admin=post_messages";
            $keyboard = ['inline_keyboard' => [[['text' => '➕ افزودن ربات به کانال', 'url' => $invite_link]]]];
            sendMessage($chat_id, "✅ عضویت شما تایید شد.\n\n<b>مرحله آخر:</b>\nبرای دریافت فایل(ها)، یک کانال بسازید و ربات را در کانال خود ادمین کنید (دسترسی ارسال پیام).", $keyboard);
            $stmt->close();
            exit();
        }
        
        $stmt->bind_result($target_channel_id);
        $stmt->fetch();
        $stmt->close();
        
        sendMessage($chat_id, "⏳ درحال ارسال فایل ها به کانال شما... لطفا صبور باشید.");
        var_log("Sending " . count($files_to_send) . " files to channel: " . $target_channel_id);
        
        // دریافت کپشن فعال
        $active_caption = getActiveCaption();
        
        $success_count = 0;
        foreach($files_to_send as $file_data) {
            if(sendFile($target_channel_id, $file_data['file_id'], $file_data['file_type'], $active_caption)) {
                $success_count++;
            }
            sleep(1);
        }
        
        $caption_status = $active_caption ? " (با کپشن)" : "";
        sendMessage($chat_id, "✅ {$success_count} فایل از " . count($files_to_send) . " فایل با موفقیت به کانال شما ارسال شد!{$caption_status}");

    }
    elseif ($text == '/start' && $user_id != ADMIN_ID) {
         sendMessage($chat_id, "👋 سلام!\n\nبرای دریافت فایل، باید از لینکی که از طرف ادمین ارسال شده استفاده کنید.");
    }

}
elseif (isset($update['my_chat_member'])) {
    $my_chat_member = $update['my_chat_member'];
    $user_who_added = $my_chat_member['from'];
    $channel_info = $my_chat_member['chat'];
    
    if ($channel_info['type'] == 'channel' && $my_chat_member['new_chat_member']['status'] == 'administrator') {
        $user_id = $user_who_added['id'];
        $channel_id = $channel_info['id'];
        $channel_title = $channel_info['title'];
        
        $stmt = $conn->prepare("INSERT INTO user_target_channels (user_id, channel_id, channel_title) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE channel_id = ?, channel_title = ?");
        $stmt->bind_param("iisis", $user_id, $channel_id, $channel_title, $channel_id, $channel_title);
        $stmt->execute();
        
        sendMessage($user_id, "✅ ربات با موفقیت به کانال '{$channel_title}' اضافه شد.\n\nاکنون می‌توانید از لینک‌های اشتراک‌گذاری استفاده کنید.");
        var_log("Bot added to channel: " . $channel_title);
    }
}

?>