<?php
// cron.php

// این فایل باید توسط کرون جاب سرور اجرا شود (مثلا هر دقیقه)

require_once 'config.php';
require_once 'db.php';
require_once 'bot.php'; // توابع apiRequest و ... رو ازش لازم داریم

// یک پیام در حال ارسال یا در صف انتظار رو پیدا کن
$broadcast_res = $conn->query("SELECT * FROM broadcasts WHERE status IN ('pending', 'sending') LIMIT 1");
if ($broadcast_res->num_rows == 0) {
    // هیچ پیامی برای ارسال نیست
    exit('No pending broadcasts.');
}

$broadcast = $broadcast_res->fetch_assoc();
$broadcast_id = $broadcast['id'];
$admin_chat_id = $broadcast['admin_id'];
$message_to_forward = $broadcast['message_id'];

// اگر اولین باره که این پیام اجرا میشه، وضعیتش رو به 'در حال ارسال' تغییر بده
if ($broadcast['status'] == 'pending') {
    $conn->query("UPDATE broadcasts SET status = 'sending' WHERE id = $broadcast_id");
}

$limit = 100; // تعداد ارسال در هر بار اجرای کرون جاب

// --- ارسال به کاربران ---
$users_res = $conn->query("SELECT user_id FROM users WHERE user_id > {$broadcast['last_processed_user_id']} ORDER BY user_id ASC LIMIT $limit");
$user_count_this_run = $users_res->num_rows;
$last_user_id = $broadcast['last_processed_user_id'];

if ($user_count_this_run > 0) {
    while($user = $users_res->fetch_assoc()) {
        try {
            apiRequest('forwardMessage', [
                'chat_id' => $user['user_id'],
                'from_chat_id' => $admin_chat_id,
                'message_id' => $message_to_forward
            ]);
        } catch (Exception $e) { /* ignore user block */ }
        $last_user_id = $user['user_id'];
        usleep(100000); // 0.1 ثانیه تاخیر
    }
    // آپدیت آخرین آیدی پردازش شده
    $conn->query("UPDATE broadcasts SET last_processed_user_id = $last_user_id, sent_to_users = sent_to_users + $user_count_this_run WHERE id = $broadcast_id");
}


// --- ارسال به کانال ها ---
$channels_res = $conn->query("SELECT channel_id FROM user_target_channels WHERE id > {$broadcast['last_processed_channel_id']} ORDER BY id ASC LIMIT $limit");
$channel_count_this_run = $channels_res->num_rows;
$last_channel_id = $broadcast['last_processed_channel_id'];

if ($channel_count_this_run > 0) {
    while($channel = $channels_res->fetch_assoc()) {
        try {
            apiRequest('forwardMessage', [
                'chat_id' => $channel['channel_id'],
                'from_chat_id' => $admin_chat_id,
                'message_id' => $message_to_forward
            ]);
        } catch (Exception $e) { /* ignore bot not being admin */ }
        $last_channel_id = $channel['id']; // توجه: اینجا از id خود جدول استفاده میکنیم
        usleep(100000);
    }
    $conn->query("UPDATE broadcasts SET last_processed_channel_id = $last_channel_id, sent_to_channels = sent_to_channels + $channel_count_this_run WHERE id = $broadcast_id");
}


// اگر در این اجرا، هیچ کاربر یا کانال جدیدی پیدا نشد، یعنی ارسال تمام شده
if ($user_count_this_run == 0 && $channel_count_this_run == 0) {
    $conn->query("UPDATE broadcasts SET status = 'sent' WHERE id = $broadcast_id");
    sendMessage($admin_chat_id, "✅ پیام همگانی شما با موفقیت برای همه کاربران و کانال‌ها ارسال شد.");
}

echo "Cron job finished.";
$conn->close();

?>