<?php
require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

function setupDatabase($connection) {
    $sql_users = "CREATE TABLE IF NOT EXISTS `users` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `user_id` BIGINT NOT NULL UNIQUE,
      `first_name` VARCHAR(255),
      `username` VARCHAR(255) NULL,
      `admin_state` VARCHAR(50) NULL,
      `current_batch_code` VARCHAR(100) NULL,
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );";

    $sql_files = "CREATE TABLE IF NOT EXISTS `files` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `admin_id` BIGINT NOT NULL,
      `file_id` VARCHAR(255) NOT NULL,
      `file_type` VARCHAR(50) NOT NULL,
      `batch_code` VARCHAR(100) NOT NULL,
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );";

    $sql_forced_channels = "CREATE TABLE IF NOT EXISTS `forced_channels` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `channel_username` VARCHAR(255) NOT NULL UNIQUE
    );";
    
    $sql_user_target_channels = "CREATE TABLE IF NOT EXISTS `user_target_channels` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `user_id` BIGINT NOT NULL UNIQUE,
      `channel_id` BIGINT NOT NULL UNIQUE,
      `channel_title` VARCHAR(255),
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );";

    $sql_broadcasts = "CREATE TABLE IF NOT EXISTS `broadcasts` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `admin_id` BIGINT NOT NULL,
      `message_id` BIGINT NOT NULL,
      `status` ENUM('pending', 'sending', 'sent') DEFAULT 'pending',
      `last_processed_user_id` BIGINT DEFAULT 0,
      `last_processed_channel_id` INT DEFAULT 0,
      `sent_to_users` INT DEFAULT 0,
      `sent_to_channels` INT DEFAULT 0,
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );";

    // جدول جدید برای کپشن‌ها
    $sql_captions = "CREATE TABLE IF NOT EXISTS `captions` (
      `id` INT AUTO_INCREMENT PRIMARY KEY,
      `admin_id` BIGINT NOT NULL,
      `caption_text` TEXT,
      `is_active` BOOLEAN DEFAULT TRUE,
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );";

    if (!$connection->query($sql_users) || 
        !$connection->query($sql_files) ||
        !$connection->query($sql_forced_channels) ||
        !$connection->query($sql_user_target_channels) ||
        !$connection->query($sql_broadcasts) ||
        !$connection->query($sql_captions)) {
        die("Error creating tables: " . $connection->error);
    }
}

setupDatabase($conn);
?>