<?php
/**
 * Configuration File - Uploader Pro Multi-Bot System
 * Version: 4.0
 * Author: DeepSeek
 * Security Level: High
 */

// =====================================
//  تنظیمات امنیتی و دیباگ
// =====================================
error_reporting(0); // غیرفعال کردن نمایش خطاها در محیط عملیاتی
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/logs/error.log');

// حالت توسعه (true = فعال)
define('DEV_MODE', false);

// =====================================
//  تنظیمات پایگاه داده (SQL)
// =====================================
define('DB_HOST', 'localhost');      // هاست دیتابیس
define('DB_USER', 'db_username');    // نام کاربری دیتابیس
define('DB_PASS', 'StrongPassword!@#123'); // رمز عبور دیتابیس
define('DB_NAME', 'uploader_pro_db'); // نام دیتابیس
define('DB_PORT', 3306);             // پورت دیتابیس

// =====================================
//  تنظیمات سرور و مسیرها
// =====================================
define('BASE_URL', 'https://yourdomain.com'); // آدرس اصلی سایت
define('UPLOAD_DIR', __DIR__ . '/uploads/');  // مسیر ذخیره فایل‌ها
define('MAX_FILE_SIZE', 20 * 1024 * 1024);    // حداکثر حجم فایل (20MB)

// =====================================
//  تنظیمات مولتی‌بات
// =====================================
// توکن‌های ربات‌ها (به صورت آرایه)
$botTokens = [
    'bot1' => 'توکن_ربات_اول',  // جایگزین کن
    'bot2' => 'توکن_ربات_دوم',  // جایگزین کن
    'bot3' => 'توکن_ربات_سوم',  // جایگزین کن
    'bot4' => 'توکن_ربات_چهارم' // جایگزین کن
];

// تنظیمات Load Balancing
define('BOT_LOAD_LIMIT', 100);    // حداکثر درخواست همزمان برای هر ربات
define('AUTO_FAILOVER', true);     // فعال‌سازی سیستم Failover خودکار

// =====================================
//  تنظیمات فایل‌ها و انقضا
// =====================================
define('FILE_EXPIRE_HOURS', 72);   // مدت اعتبار لینک‌ها (ساعت)
define('FILE_ID_LENGTH', 32);      // طول شناسه فایل
define('ALLOWED_FILE_TYPES', serialize([
    'image/jpeg', 'image/png', 'image/gif',
    'application/pdf', 'text/plain',
    'application/msword',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'video/mp4', 'audio/mpeg',
    'application/zip', 'application/x-rar-compressed'
]));

// =====================================
//  تنظیمات امنیتی پیشرفته
// =====================================
define('ENCRYPTION_KEY', bin2hex(random_bytes(32))); // کلید رمزنگاری
define('IP_WHITELIST', serialize(['127.0.0.1']));   // IP های مجاز برای مدیریت
define('ANTI_FLOOD_DELAY', 2);      // تاخیر بین درخواست‌ها (ثانیه)
define('MAX_REQUESTS_PER_MINUTE', 30); // حداکثر درخواست در دقیقه

// =====================================
//  تنظیمات لوگو و برندینگ
// =====================================
define('APP_NAME', 'Uploader Pro');
define('APP_VERSION', '4.0');
define('ADMIN_USER_ID', 123456789); // آی‌دی کاربر ادمین

// =====================================
//  تنظیمات جانبی
// =====================================
date_default_timezone_set('Asia/Tehran'); // منطقه زمانی
define('MAX_DOWNLOAD_PER_FILE', 1000);    // حداکثر دانلود برای هر فایل

// =====================================
//  تابع اتصال به دیتابیس (اختیاری)
// =====================================
function getDbConnection() {
    static $conn = null;
    
    if ($conn === null) {
        try {
            $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
            $conn->set_charset("utf8mb4");
            
            if ($conn->connect_error) {
                error_log("DB Connection Failed: " . $conn->connect_error);
                die("System maintenance. Please try again later.");
            }
        } catch (Exception $e) {
            error_log("DB Exception: " . $e->getMessage());
            die("Database connection error");
        }
    }
    
    return $conn;
}

// =====================================
//  تابع بررسی IP ادمین
// =====================================
function isAdminIP() {
    $clientIP = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    $whitelist = unserialize(IP_WHITELIST);
    return in_array($clientIP, $whitelist);
}

// =====================================
//  جلوگیری از دسترسی مستقیم به فایل
// =====================================
if (basename($_SERVER['PHP_SELF']) === 'config.php') {
    header('HTTP/1.1 403 Forbidden');
    die("Access forbidden");
}
?>